﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Towary" %>
<%@ import Namespace="Soneta.Magazyny" %>
<script runat="server">

    void Grid_ItemsGet(Object sender, ItemsGetEventArgs args) {
        if (args.Deep==1) {    
            Towar t = (Towar)args.Row;

            if (pars.Magazyny.Length == 1)            
                args.Enumerable = t.Module.Magazyny.Zasoby.WgTowar[t, pars.Okres, pars.Magazyny[0]];
            else
                args.Enumerable = t.Module.Magazyny.Zasoby.WgTowar[t, pars.Okres];            
        }
    }
    
    void Grid_BeforeRow(Object sender, RowEventArgs args) {
        Zasob z = (Zasob)args.Row;
        args.VisibleRow = (z.Partia.Typ == TypPartii.Magazynowy || z.Partia.Typ == TypPartii.Zamówiony || z.Partia.Typ == TypPartii.Zarezerwowany) &&
            z.Kierunek == KierunekPartii.Rozchód && Array.Exists<Magazyn>(pars.Magazyny, mag => mag == z.Magazyn);
    }

    ObrotyParams pars;
    protected void dc_ContextLoad(object sender, EventArgs e) {
        pars = (Soneta.Magazyny.ObrotyParams)dc[typeof(Soneta.Magazyny.ObrotyParams)];
        checkObrotyPars(pars);     
        ReportHeader.Title = String.Format("Stany magazynowe - ujemne|</STRONG>Okres magazynowy:<STRONG> {0}|</STRONG>Magazyn:<STRONG> {1}|</STRONG>Dostawca:<STRONG> {2}|</STRONG>Stan na dzień:<STRONG> {3:b}",
        pars.Okres, WydrukiTools.WydrukiStanyMagazynoweLista.FormatMagazyny(pars.Magazyny), pars.Dostawca, pars.DataStanu);        
    }

    private void checkObrotyPars(ObrotyParams pars) {
        if (pars == null)                    
            throw new ArgumentNullException("ObrotyParams pars");       
        if (pars.Magazyny == null || (pars.Magazyny != null && pars.Magazyny.Length == 0))
            throw new InvalidOperationException("Wymagane jest wybranie przynajmniej jednego magazynu.");
    }
    
   
    
</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>Stany magazynowe</title> 
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form method="post" runat="server" action="#">
        <ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
        <eb:ReportHeader id="ReportHeader" runat="server"></eb:ReportHeader>
        <ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Magazyny.Zasob,Soneta.Handel" OnItemsGet="Grid_ItemsGet" 
            GroupLine="Towar: {1} - {0}" ShowGroupSum="True" GroupData0="Towar.Nazwa" GroupData1="Towar.Kod" OnBeforeRow="Grid_BeforeRow">
            <Columns>
                <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." EncodeHTML="True" runat="server"></ea:GridColumn>
                <ea:GridColumn Caption=" " EncodeHTML="True" runat="server"></ea:GridColumn>
                <ea:GridColumn Width="10" DataMember="Kierunek" EncodeHTML="True" runat="server"></ea:GridColumn>
                <ea:GridColumn Width="20" Align="Right" DataMember="Partia.Dokument" Total="Info" Caption="Dokument" EncodeHTML="True" runat="server"></ea:GridColumn>
                <ea:GridColumn Width="14" Align="Right" DataMember="IlośćZasobu" Total="Sum" Caption="Ilość" EncodeHTML="True" runat="server"></ea:GridColumn>
                <ea:GridColumn Width="14" Align="Right" DataMember="Partia.Cena" Caption="Cena" Format="{0:n}" EncodeHTML="True" runat="server"></ea:GridColumn>
                <ea:GridColumn Width="14" Align="Right" DataMember="Partia.Wartosc" Total="Sum" Caption="Wartość" Format="{0:n}" EncodeHTML="True" runat="server"></ea:GridColumn>
            </Columns>
        </ea:Grid>
        <eb:ReportFooter id="ReportFooter" runat="server" PrintDate="true" PrintTime="true"></eb:ReportFooter>
    </form>
</body>
</html>
